<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {


public function __construct()
	{
	parent::__construct();
	
	$this->load->model('admin');
	
	$this->admin->prepare();
	}

public function _remap() 
	{
	
	$this->admin->model('users');
	
	if($this->uri->segment(3)=='edit')
		{
		$this->edit();	
		}
	elseif($this->uri->segment(3)=='profile')
		{
		$this->profile();	
		}
	else
		{
		$this->index();	
		}
	}

// Listing	
public function index()
	{
	// Get the list
	$this->users->search();
	
	// Define the Toolbar
	$this->admin->toolbar('link', 'New '.$this->users->name, 'fa-plus', '', $this->users->link, '');
	
	$this->admin->output();
	}

// Edit Form	
public function edit()
	{
	// Get the record
	$this->users->get();
	
	// Define the Toolbar
	$this->admin->toolbar('save', 'Save '.$this->users->name, 'fa-check', 'form', '', '');
	$this->admin->toolbar('idfunc', 'Reset Password', 'fa-refresh', $this->users->index, strtolower($this->users->name), 'resetpass');
	$this->admin->toolbar('link', 'New '.$this->users->name, 'fa-plus', '', $this->users->link, '');
	$this->admin->toolbar('link', $this->users->name.' Listing', 'fa-navicon', '', $this->users->base, '');
	
	$this->admin->js('users.inc.js');
	
	$this->admin->notabs = 1;
	
	$this->admin->output();
	}

// Edit Form	
public function profile()
	{
	$this->users->value = $this->shake->user['id'];
	// Get the record
	$this->users->get();
	
	$this->admin->view = 'user/profile';
	
	// Define the Toolbar
	$this->admin->toolbar('save', 'Save Profile', 'fa-check', 'form', '', '');
	
	$this->admin->js('users.inc.js');
	
	$this->admin->notabs = 1;
	
	$this->admin->output();
	}



}