<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Page extends CI_Model {

// View and Global Settings
var $siteid		= '1';
var $site 		= array();
var $sitename	= '';
var $theme		= '';

var $view		= '';
var $inline		= '0';
var $elements	= array();

// Page Variables
var $coid		= '';
var $type		= ''; 		// Page type
var $title 		= ''; 		// Content title
var $info		= array(); 	// Content info
var $flyer		= array();	// Variable record data for passing through common calls

// Caching Config
var $cch		= '0';
var $timer		= '';		// How long the page should last for before having to be refreshed. Minutes


// URLs
var $coids		= array();	// Construct available, used for querying pages just before output for any items that require full URLs to items
var $urls		= array();	// URLs for the items on the page
var $urlset		= array();	// Master set
var $urltype	= array();	// URL mater set by type

// Construct arrays [See css() and js() functions below for building the arrays]
var $css 		= array();
var $js 		= array();

// Menus
var $menu 		= array();


// User
var $user 		= array();
var $data		= array();

// Pagination
var $paging		= array();	// Config
var $links		= '';		// Output
var $number		= '';		// Current Page
var $total		= 0; 		// Total
var $limit		= 2; 		// Limit
var $offset		= 0;		// Offset


// Page Form Variables
var $valid 		= '';		// Error response construct
var $required 	= array();	// Required fields array
var $postdata 	= array(); 	// Postdata (merge of post and get)
var $response 	= array();	// Response variables
var $record		= array();	// Record array
var $related	= array();	// Related articles
var $validated	= true;		// Validation boolean


public function __construct()
	{
	parent::__construct();
	
	$this->load->helper('directory');
	
	$this->load->model('page/schema');
	
	$this->load->model('page/meta');
	
	$this->load->model('page/fields');
	
	//$this->load->driver('cache');
	}

/**
 *	Prepare SMEWS Admin
 */ 
public function prepare()
	{
	if(!isset($_SERVER['HTTPS']))
		{
		header("HTTP/1.1 301 Moved Permanently");
		header('Location: https://'.$_SERVER['HTTP_HOST'].'/'.$this->uri->uri_string());
		die();
		}
		
	// Site Info
	$this->site();
	
	// Set Menus
	$this->menu();
	
	
	
	// Redirect and URL Formatter
	//$this->redirecter();
	
	// Set Postdata and User
	$this->data();
		
	// Set Menus
	$this->user();
	
	// Load the page record
	$this->get();
	
	$this->related();
	
	// Now load models from the auto directory and run the prep funcs
	$this->autoloader();
	
	// Now run the page extensions for awesomeness
	$this->meta->init();
	
	$this->schema->init();
	
	$this->tracking();
	//echo '<pre>';die(print_r($this->info));
	
	$this->urls();
	}

public function ajax()
	{
	// Site Info
	$this->site();
	
	// Set Menus
	$this->user();
	
	// Set Postdata and User
	$this->data();
	
	}

public function autoloader()
	{
	$loader = directory_map(APPPATH.'/models/auto/', 1);
	
	
	foreach($loader as $model)
		{
		$model = str_replace('.php', '', strtolower($model));
		
		if($model!='' && !in_array($model, array('_notes/', 'index', 'index.html', '.htaccess')))
			{
			$this->load->model('auto/'.$model);	
			
			if(method_exists($this->$model, 'prepare'))
				{
				$this->$model->prepare();	
				}
			}
		}	
	}


/**
 *	Load Site Master
 */ 
public function site()
	{
	//$this->db->cache_on();
	$this->site = $this->db->where(array('siteid' => $this->siteid))->get('master')->row_array();
	//$this->db->cache_off();
	
	
	// Define some common variables	
	$this->sitename 	= stripslashes($this->site['sitename']);
	$this->theme 		= stripslashes($this->site['sitetheme']);
	
	
	$offices = $this->site['onecastoffice']!='' ? json_decode($this->site['onecastoffice'], true) : array();
	
	if(!empty($offices))
		{
		foreach($offices as $office)
			{
			$this->site['onecastoffices'][$office] = $office;	
			}
		}
	}


/**
 *	Redirect and URL Formatter
 */ 
public function redirecter()
	{
	$requrl = $_SERVER['HTTP_HOST'];
	
	$urlparts = explode('.', $requrl);
	
	if($urlparts[0]!='www')
		{
		header("HTTP/1.1 301 Moved Permanently");
		//header('Location: http://www.'.$_SERVER['HTTP_HOST'].'/'.$this->uri->uri_string());
		die();
		}
		
	//die($this->uri->uri_string());
	if($this->uri->uri_string())
		{
		$r = $this->db	->where('redirectfrom', '/'.$this->uri->uri_string())
						->or_where('redirectfrom', '/'.$this->uri->uri_string().'/')
						->or_where('redirectfrom', $this->uri->uri_string().'/')
						->or_where('redirectfrom', $this->uri->uri_string())
						->join('content', 'content.coid = redirects.coid')
						->limit(1)
						->get('redirects')->row_array();
		
		if(!empty($r))
			{
			$u = isset($this->urls[$r['coid']]) ? $this->urls[$r['coid']] : '';
			header('HTTP/1.1 301 Moved Permanently');
			header('Location: http://'.$this->site['siteurl'].'/'.$u);
			die();
			}
		
		if(substr($_SERVER['REQUEST_URI'],-1)=='/')
			{
			$u = isset($this->urls[$r['coid']]) ? $this->urls[$r['coid']] : '';
			header('HTTP/1.1 301 Moved Permanently');
			header('Location: http://'.$this->site['siteurl'].'/'.$this->uri->uri_string());
			die();	
			}
		}
	}


/**
 *	Catch User
 */ 
public function user()
	{
	// User loading
	if(	$this->site['siteopen']=='2' && $this->input->get('key') && $this->input->get('key')==$this->site['closurekey'] || 
		$this->session->userdata('pcms_open') && $this->session->userdata('pcms_open')==$this->site['closurekey'])
		{
		$this->site['siteopen'] = '1';
		}
	
	if($this->input->get('key') && $this->input->get('key')==$this->site['closurekey'])
		{
		$this->session->set_userdata('pcms_open', $this->site['closurekey']);	
		}
	
	$this->user = $this->session->userdata();
	
	}


/**
 *	Catch Post and Get
 */ 
public function data()
	{
	// Catch Post and Get Data
	$this->postdata = array_merge($this->input->post(), $this->input->get());
	}

/**
 *	Record Visitor, If Tracking Enabled
 */ 
public function tracking()
	{
	if($this->site['siteanalytics']==1)
		{
		$this->load->model('page/analytics');
		
		$this->analytics->init();
		}
	}



/**
 *	Inline Manager
 */ 

public function inline($v)
	{
	$this->inline = $v; return $this;	
	}

/**
 *	Prepare Menu
 */ 
public function menu()
	{
	//$this->db->cache_on();
	$top = $this->db->select('coid, pcoid, contenttitle, contenttitlecurl, contentorder, contentrealorder, contentmenuclass')->where(array('contentactive' => 1, 'contentmainmenu' => 1))->order_by('contentnodel')->get('content')->result_array();
	//$this->db->cache_off();
	
	$this->menuformatter($top, 'top');
	
	//$this->db->cache_on();
	$foot = $this->db->select('coid, pcoid, contenttitle, contenttitlecurl, contentorder, contentrealorder')->where(array('contentactive' => 1, 'contentfootmenu' => 1))->order_by('contentnodel')->get('content')->result_array();
	//$this->db->cache_off();
	
	$this->menuformatter($foot, 'foot');
	
	//echo '<pre>';die(print_r($this->menu));
	}

private function menuformatter($list, $type)
	{
	$menu = array();
	
	foreach($list as $item)
		{
		if($item['pcoid']!='0')
			{
			$this->menu['child'][$item['pcoid']] = $item;
			$this->menu[$type][$item['pcoid']]['children'][$item['coid']] = $item;	
			}
		else
			{
			$this->menu[$type][$item['coid']] = $item;	
			}
		}	
	}


/**
 *	Get URLs for Page Items
 */ 
public function urls()
	{
	$list = array();
	// Get root level articles first
	//$this->db->cache_on();
	if(!empty($this->coids)){$this->db->where_in('coid', $this->coids);}
	$part = $this->db->select('content.coid, content.pcoid, content.contenttype, content.contenttitle, content.contentmainmenu, content.contenttitlecurl, contenttypes.contenttype, contenttypes.contenttypeunique')->join('contenttypes', 'contenttypes.ctid = content.ctid', 'left')->where(array('contentactive' => 1, 'pcoid' => 0))->order_by('contentrealorder')->get('content')->result_array();
	//$this->db->cache_off();
	
	if(!empty($part))
		{
		foreach($part as $art)
			{
			$coid = $art['coid'];
			
			$url = $art['contenttype']=='home' ? '/' : '/'.$art['contenttitlecurl'];
				
			$this->urls[$coid] = $url;
			
			if($art['contenttypeunique']=='1')
				{
				$this->urltype[$art['contenttype']] = $url;
				}
			}
		}
	
	// Now get all non-root articles
	//$this->db->cache_on();
	if(!empty($this->coids)){$this->db->where_in('coid', $this->coids);}
	$cart = $this->db->select('coid, pcoid, contenttype, contenttitle, contentmainmenu, contenttitlecurl')->where(array('contentactive' => 1, 'pcoid !=' => 0))->order_by('contentrealorder')->get('content')->result_array();
	//$this->db->cache_off();
	
	if(!empty($cart))
		{
		foreach($cart as $art)
			{
			$coid = $art['coid'];
			
			$pcoid = $art['pcoid'];
			
			if(isset($this->urls[$pcoid]))
				{
				$url = $this->urls[$pcoid].'/'.$art['contenttitlecurl'];	
				
				$this->urls[$coid] = $url;
				}
			}
		}
	}

public function urlset()
	{
	$list = array();
	// Get root level articles first
	$part = $this->db->select('coid, pcoid, contenttype, contenttitle, contentmainmenu, contenttitlecurl')->where(array('contentactive' => 1, 'pcoid' => 0))->order_by('contentrealorder')->get('content')->result_array();
	
	if(!empty($part))
		{
		foreach($part as $art)
			{
			$coid = $art['coid'];
			
			$url = $art['contenttype']=='home' ? '/' : '/'.$art['contenttitlecurl'];
				
			$this->urlset[$coid] = $url;
			}
		}
	
	// Now get all non-root articles
	$cart = $this->db->select('coid, pcoid, contenttype, contenttitle, contentmainmenu, contenttitlecurl')->where(array('contentactive' => 1, 'pcoid !=' => 0))->order_by('contentrealorder')->get('content')->result_array();
	
	if(!empty($cart))
		{
		foreach($cart as $art)
			{
			$coid = $art['coid'];
			
			$pcoid = $art['pcoid'];
			
			if(isset($this->urlset[$pcoid]))
				{
				$url = $this->urlset[$pcoid].'/'.$art['contenttitlecurl'];	
				
				$this->urlset[$coid] = $url;
				}
			}
		}
	}


/**
 *	Get Page
 */ 
public function get()
	{
	if($this->page->site['siteopen']==1)
		{
		if($this->uri->segment(1))
			{
			$part = $this->uri->total_segments();
			
			$curl = $this->uri->segment($part);
			
			if($part > 1)
				{
				$p = $this->db->select('coid')->where('contenttitlecurl', $this->uri->segment($part-1))->limit(1)->get('content')->row_array();
				
				if(!empty($p))
					{
					$this->db->where('pcoid', $p['coid']);	
					}
				}
			
			//$this->db->cache_on();
			$q = $this->db->select('content.*, users.userfullname AS contentauthor')->where(array('contentactive' => 1, 'contenttitlecurl' => $curl))->join('users', 'users.usid = content.contenteditor', 'left')->limit(1)->get('content')->row_array();
			//$this->db->cache_off();
			}
		else
			{
			//$this->db->cache_on();
			$q = $this->db->select('content.*, users.userfullname AS contentauthor')->where(array('contentactive' => 1, 'contenttype' => 'home'))->join('users', 'users.usid = content.contenteditor', 'left')->limit(1)->get('content')->row_array();
			//$this->db->cache_off();
			}
		
		if(!empty($q))
			{
			$this->info 	= $q;
			
			$this->coid 	= $this->info['coid'];
			
			$this->title 	= $this->info['contentpagetitle']!='' ? stripslashes($this->info['contentpagetitle']) : stripslashes($this->info['contenttitle']);
			
			$this->type 	= stripslashes($this->info['contenttype']);
			
			$this->elements(); 
			}
		else
			{
			$this->elements = array('error');
			$this->output->set_status_header('404');
			$this->title = $this->info['contentpagetitle'] = 'Page Not Found';
			$this->type = 'error';
			$this->view = '';
			$this->info['contentshowtitle'] = '1';
			$this->info['contentarticle'] = $this->page->site['errormessage'];
			}
		}
	else
		{
		$this->elements = array('article');
		$this->title = $this->info['contentpagetitle'] = 'Closed for Maintenance';
		$this->type = 'article';
		$this->view = '';
		$this->info['contentshowtitle'] = '1';
		$this->info['contentarticle'] = $this->page->site['closedmessage'];	
		}
	}

public function related()
	{
	if(in_array('related', $this->elements))
		{
		if($this->info['pcoid']!='0')
			{
			$this->related = $this->db	->select('coid, pcoid, contenttitle, contentpagetitle, contenttitlecurl')
										->where('pcoid', $this->info['pcoid'])
										->order_by('contentnodel')
										->get('content')->result_array();
			}
		else
			{
			$this->related = $this->db	->select('coid, pcoid, contenttitle, contentpagetitle, contenttitlecurl')
										->where('pcoid', $this->info['coid'])
										->order_by('contentnodel')
										->get('content')->result_array();	
			}
		}
	}

public function paging()
	{
	if($this->site['ajaxpaging']==1)
		{
		$this->coid = isset($this->page->postdata['coid']) && $this->coid=='' ? $this->page->postdata['coid'] : $this->coid;
		
		if($this->site['viewportpaging']==1)
			{	
			if($this->paging['offset'] < $this->paging['total'])
				{
				$this->paging['page'] = $this->paging['page']!='' ? $this->paging['page'] : 1;
				
				$this->paging['output'] = '<div id="viewport-paging" paging-id="'.$this->coid.'" paging-type="'.$this->paging['type'].'" paging-list="'.$this->paging['list'].'" paging-total="'.$this->paging['total'].'" paging-offset="'.$this->paging['offset'].'" paging-limit="'.$this->paging['limit'].'"></div>';
				}
			else
				{
				$this->paging['output'] = '';	
				}
			}
		else
			{
			if($this->page->paging['finish'] < $this->page->paging['total'])
				{
				$counter = 'Showing products 1 to '.$this->page->paging['finish'].' of '.$this->page->paging['total'].'. Click to Show More.';
				}
			else
				{
				$counter = 'Showing all products.';
				}
			
			$this->paging['page'] = $this->paging['page']!='' ? $this->paging['page'] : 1;
			$this->paging['output'] = '<div id="inline-paging" paging-id="'.$this->coid.'" paging-type="'.$this->paging['type'].'" paging-list="'.$this->paging['list'].'" paging-total="'.$this->paging['total'].'" paging-offset="'.$this->paging['offset'].'" paging-limit="'.$this->paging['limit'].'">'.$counter.'</div>';
			}
		
		echo $this->paging['output'];
		}
	else
		{
		// Set the Paging
		$this->load->library('pagination');
		
		$segs = $this->uri->total_segments();
		
		if($segs > 1 && $this->uri->segment($segs-1)=='page')
			{
			$this->pageuri = $segs;	
			}
		elseif($this->uri->segment($segs)=='page')
			{
			$this->pageuri = $segs + 1;	
			}
		else
			{
			$this->pageuri = $segs + 2;	
			}
		
		$this->paging['base_url'] 			= '/'.$this->uri->uri_string().'/page/';
		$this->paging['total_rows'] 		= $this->total;
		$this->paging['per_page'] 			= $this->limit;
		$this->paging['uri_segment'] 		= $this->pageuri;
		$this->paging['use_page_numbers'] 	= TRUE;
		$this->paging['page_query_string'] 	= FALSE;
		
		$this->pagination->initialize($this->paging);
		
		echo $this->pagination->create_links();
		}
	}



/**
 *	COID Builder
 */
public function coid($k)
	{
	if(is_array($k))
		{
		foreach($k as $c)
			{
			$this->coids[] = $c;	
			}
		}
	else
		{
		$this->coids[] = $k;	
		}
	
	return $this;
	}

/**
 *	CSS and JS Include Builder
 */
public function css($k)
	{
	if(is_array($k))
		{
		foreach($k as $c)
			{
			$this->css[] = $c;	
			}
		}
	else
		{
		$this->css[] = $k;	
		}
	
	return $this;
	}

public function js($k)
	{
	if(is_array($k))
		{
		foreach($k as $c)
			{
			$this->js[] = $c;	
			}
		}
	else
		{
		$this->js[] = $k;	
		}
	
	return $this;
	}


/**
 *	Form Validation
 */
public function required($f, $m=NULL)
	{
	if(is_array($f))
		{
		foreach($f as $i => $e)
			{
			$this->required[$i] = $e;	
			}
		}
	else
		{
		$this->required[$f] = $m;
		}
	
	return $this;
	}

public function validate()
	{
	$this->validated = true;
	
	if(!empty($this->required))
		{
		foreach($this->required as $f => $m)
			{
			if(!isset($this->postdata[$f]) || $this->postdata[$f]=='')
				{
				$this->valid .= $m.'<br />';	
				}
			}
		}
	
	if($this->valid!='')
		{
		$this->error($this->valid);	
		}
	
	return $this;
	}

/**
 *	Alert Builder and JSON responder
 */ 
public function response($fld, $var=NULL)
	{
	if(is_array($fld))
		{
		$this->response = !empty($this->response) ? array_merge($this->response, $fld) : $fld;
		}
	elseif($var!=NULL)
		{
		$this->response[$fld] = $var;
		}
	
	return $this;
	}

public function success($msg, $id=NULL)
	{
	if(!isset($this->response['error']))
		{
		$this->response['success'] = isset($this->response['success']) ? $this->response['success'].'<br />'.$msg : $msg;
		
		if($id!=NULL)
			{
			$this->response['newid'] = $id;	
			}
		}
	
	return $this;
	}
	
public function error($msg)
	{
	$this->response['error'] = isset($this->response['error']) ? $this->response['error'].'<br />'.$msg : $msg;
	
	$this->validated = false;
	
	return $this;
	}

public function respond()
	{
	$this->output->set_content_type('application/json')->set_output(json_encode($this->response));	
	
	return $this;
	}


/**
 *	View / Data Output
 */ 
public function common($view)
	{
	if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/common/'.$view.'.php'))
		{
		$this->load->view('../../'.$this->theme.'/views/common/'.$view, array());	
		}
	else
		{
		$this->load->view('common/'.$view, array());
		}
	}
	
public function view()
	{
	if($this->view!='')
		{
		if(is_array($this->view))
			{
			foreach($this->view as $view)
				{
				if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/'.$view.'.php'))
					{
					$this->load->view('../../'.$this->theme.'/views/'.$view, array());	
					}
				else
					{
					$this->load->view($view, array());	
					}
				}
			}
		else
			{
			if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/'.$this->view.'.php'))
				{
				$this->load->view('../../'.$this->theme.'/views/'.$this->view, array());	
				}
			else
				{
				$this->load->view($this->view, array());
				}
			
			}
		}
	
	if(!empty($this->elements))
		{
		foreach($this->elements as $element)
			{
			$this->element($element);
			}
		}
	}

public function elements()
	{
	$e = isset($this->info['contentelements']) ? json_decode($this->info['contentelements']) : '';
	
	$this->elements = (array)$e;
	
	foreach($this->elements as $k => $ele)
		{
		$this->elements[$ele] = $ele;
		
		unset($this->elements[$k]);
		
		$el = explode('/', $ele);
				
		$m = $el[0];
		
		if(class_exists($m)===false && file_exists(APPPATH.'/models/elements/'.ucfirst($m).'.php'))
			{
			$this->load->model('elements/'.$m);
			
			if(method_exists($this->$m, 'prepare'))
				{
				$this->$m->prepare();	
				}
			}
		}
	
	}

public function element($element)
	{
	if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/elements/'.$element.'.php'))
		{
		if($this->inline==1)
			{
			return $this->load->view('../../'.$this->theme.'/views/elements/'.$element, array(), true);
			}
		else
			{
			$this->load->view('../../'.$this->theme.'/views/elements/'.$element, array());	
			}
		}
	elseif(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/_pelco/views/elements/'.$element.'.php'))
		{
		if($this->inline==1)
			{
			return $this->load->view('elements/'.$element, array(), true);	
			}
		else
			{
			$this->load->view('elements/'.$element, array());	
			}
		}
	}

public function emltpl($tpl)
	{
	if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/emails/'.$tpl.'.php'))
		{
		return $this->load->view('../../'.$this->theme.'/emails/'.$tpl, array(), true);
		}
	elseif(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/_pelco/emails/'.$tpl.'.php'))
		{
		return $this->load->view('../emails/'.$emails, array(), true);	
		}
	}

public function info($var, $pre=NULL)
	{
	if(isset($this->page->info[$var]) && $this->page->info[$var]!=''){echo $pre.$this->page->info[$var];}
	}

public function flyer($var, $pre=NULL)
	{
	if(isset($this->page->flyer[$var]) && $this->page->flyer[$var]!=''){echo $pre.$this->page->flyer[$var];}
	}

/**
 *	Output Page
 */
public function output()
	{
	$this->common('header');
	
	$this->view();
	
	$this->common('footer');
	
	if($_SERVER['REMOTE_ADDR']=='203.206.137.6')
		{
		//$this->output->enable_profiler(true);	
		}
	}


}
