<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Banners extends CI_Model {

// Variables
var $bid 		= '';
var $value		= '';

// Listing and Editing URLs
var $name		= 'Banner';
var $base 		= 'banner/listing/';
var $link 		= 'banner/edit/';

// Edit Folder Name
var $editor 	= 'banner/edit';

// Table and Search Settings
var $table 		= 'banners';
var $index 		= 'bid';

var $select		= 'banners.*, content.contenttitle';

var $join		= array('content' => 'coid');

var $filterby 	= 'banneractive';
var $filterlbl 	= 'Status';
var $filters	= array('1' => 'Active', '2' => 'Inactive');

var $orderby 	= 'bannerorder';
var $ordering 	= 'asc';

var $options	= array('bannertitle' => 'Title', 'contenttitle' => 'Page');

// Upload Settings
var $imgfolder 	= 'banners';
var $fieldname 	= 'fileupload';
var $allowed 	= 'png|jpg|gif';

public function __construct()
	{
	parent::__construct();
	}

public function id()
	{
	$this->bid = $this->uri->segment(4) ? $this->uri->segment(4) : $this->bid;
	$this->bid = isset($this->admin->postdata['bid']) && $this->admin->postdata['bid']!='' ? $this->admin->postdata['bid'] : $this->bid;	
	}

public function search()
	{
	$this->admin->model('search');
	
	// Page View and Title
	$this->admin->view 	= 'search/gallery'; // search/listing | search/gallery
	$this->admin->title = $this->name.' Listing';
	
	// Set Common Settings
	$this->search->table		= $this->table;
	$this->search->index 		= $this->index;
	$this->search->session 		= $this->table;
	$this->search->base 		= $this->base;
	$this->search->link 		= $this->link;
	
	$this->search->process		= strtolower($this->name);
	
	$this->search->select 		= $this->select;
	$this->search->joins 		= $this->join;
	
	$this->search->options 		= $this->options;
	
	$this->search->filterby 	= $this->filterby;
	$this->search->filterlbl 	= $this->filterlbl;
	$this->search->filters 		= $this->filters;
	
	$this->search->orderby 		= $this->orderby;
	$this->search->ordering 	= $this->ordering;
	
	$this->search->no_results = 'Sorry but no banners matched your search. Please try searching again or search by a different field.';
	$this->search->no_records = 'No banners have been setup in the system yet.';
	
	$this->search->column('bannerimage', 'Image', '0', 'image', '', array('imagepath' => '/_media/banners/'));
	$this->search->column('banneractive', 'Active', '1', 'switcher');
	$this->search->column('bannerorder', 'Order', '1', 'ordering');
	$this->search->column('bannertitle', 'Title', '5', 'text');
	$this->search->column('contenttitle', 'Page', '5', 'text');
	
	// Run the Search
	$this->search->run();
	
	if($this->admin->inline==1)
		{
		$page = $this->admin->page();
		
		$views = $this->search->inline();
		
		$this->admin->response = array('success' => 'Search processed.', 'head' => $views['head'], 'list' => $views['list'], 'foot' => $views['foot']);
		
		$this->output->set_content_type('application/json')->set_output(json_encode($this->admin->response));
		}
	}

public function get()
	{
	$this->id();
	
	$this->admin->record = $this->db->select('banners.*, c.contenttitle as displaypage, l.contenttitle as linkpage')->where('bid', $this->bid)->join('content c', 'c.coid = banners.coid', 'left')->join('content l', 'l.coid = banners.lcoid', 'left')->get('banners')->row_array();
	
	$this->admin->inline = 1;
	$this->admin->images('banners');
	$this->admin->opts['bannerlist'] = $this->admin->imglist;
	$this->admin->inline = 0;
	
	// Page View and Title
	$this->admin->view = $this->editor;
	$this->admin->title = $this->name.' Editor';
	}

public function save()
	{
	$this->id();
	
	$this->admin->required(array(	'bannertitle' 	=> 'You must give the banner a title.',
									'coid' 			=> 'You must assign the banner to a display page.'
									));
	
	$this->admin->validate();
	
	if(!isset($this->admin->response['error']))
		{
		unset($this->admin->postdata['filetitle'], $this->admin->postdata['displaypage'], $this->admin->postdata['linkpage']);
		
		$this->admin->postdata['bannerimage'] = str_replace('/_media/banners/', '', $this->admin->postdata['bannerimage']);
		
		if($this->bid!='')
			{
			$this->admin->response 	= $this->db->update('banners', $this->admin->postdata, array('bid' => $this->bid)) 
									? array('success' => 'The banner has been updated.') 
									: array('error' => 'Sorry but there was an error updating the banner.');
			}
		else
			{
			$this->admin->response 	= $this->db->insert('banners', $this->admin->postdata) 
									? array('success' => 'The banner has been created.', 'newid' => $this->db->insert_id()) 
									: array('error' => 'Sorry but there was an error creating the banner.');	
			}
		}
	
	$this->admin->respond();
	}

public function upload()
	{
	$this->id();
	
	$settings = array(	'upload_path' => './_media/'.$this->imgfolder.'/',
						'allowed_types' => $this->allowed,
						);
	
	$this->load->library('upload', $settings);
	
	if($this->upload->do_upload($this->fieldname))
		{
		$this->fileinfo = $this->upload->data();
		
		$this->admin->response 	= $this->db->update('banners', array('bannerimage' => $this->fileinfo['file_name']), array('bid' => $this->bid)) 
								? array('success' => 'The banner has been uploaded and saved to the database.', 'filepath' => '/_media/'.$this->imgfolder.'/'.$this->fileinfo['file_name'], 'filename' => $this->fileinfo['file_name']) 
								: array('error' => 'The file was uploaded but there was an issue updating the banner. Try reloading the record and assigning the banner from the file selector.');
		}
	else
		{
		$this->admin->response = array('error' => 'There was an error uploading the file.<br />'.$this->upload->display_errors());	
		}
	
	$this->admin->respond();
	}

public function delete()
	{
	
	}

}