<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sitemaps extends CI_Model {

// Variables
var $coid 		= 0;
var $site 		= array();


public function __construct()
	{
	parent::__construct();
	}

	
public function generate()
	{
	$this->admin->site();
	// Define a Couple of Variables
	$list = array();
	$blog = array();
	
	// Start the XML contents
	$o = '<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
	
	
	// Get root level articles first
	$part = $this->db->where(array('contentactive' => 1, 'pcoid' => 0))->order_by('contentrealorder')->get('content')->result_array();
	
	if(!empty($part))
		{
		foreach($part as $art)
			{
			$coid = $art['coid'];
			//$ncid = $art['ncid'];
			$importance = number_format(($art['contentimportance']/10), 1, '.', '');
			$url = $art['contenttype']=='home' ? '' : $art['contenttitlecurl'];
			$o .= '
<url>
	<loc>https://'.$this->admin->site['siteurl'].'/'.$url.'</loc>
	<lastmod>'.$art['contentedited'].'</lastmod>
	<changefreq>weekly</changefreq>
	<priority>'.$importance.'</priority>
</url>';	
			$art['realurl'] = $url;
			$list[$coid] = $art;
			//if($art['pagetype']=='blog'){$blog[$ncid] = $art;}
			}
		}
	
	// Now get all non-root articles
	$cart = $this->db->where(array('contentactive' => 1, 'pcoid !=' => 0))->order_by('contentrealorder')->get('content')->result_array();
	
	if(!empty($cart))
		{
		foreach($cart as $art)
			{
			$coid = $art['coid'];
			$pcoid = $art['pcoid'];
			
			if(isset($list[$pcoid]))
				{
				$parent = $list[$pcoid];
				$url = $parent['realurl'].'/'.$art['contenttitlecurl'];	
				$importance = number_format(($art['contentimportance']/10), 1, '.', '');
				
				$o .= '
<url>
	<loc>https://'.$this->admin->site['siteurl'].'/'.$url.'</loc>
	<lastmod>'.$art['contentedited'].'</lastmod>
	<changefreq>weekly</changefreq>
	<priority>'.$importance.'</priority>
</url>';	
				$art['realurl'] = $url;
				$list[$coid] = $art;
				}
			}
		}
	
	// Finalise the output
	$o .= '
</urlset>';
	
	$this->load->helper('file');
	
	// Write to the file
	if(write_file('./sitemap.xml', $o))
		{
		// If we want to ping the sitemap then go for it
		if($this->admin->site['sitesitemapping']==1)
			{
			// Ping Sitemaps
			$url = 'http://'.$this->admin->site['siteurl'].'/sitemap.xml';
			
			// Google	= http://www.google.com/webmasters/tools/ping?sitemap=url
			$this->submit('http://www.google.com/webmasters/tools/ping?sitemap='.$url);
			
			// BING 	= http://www.bing.com/ping?sitemap=url
			$this->submit('http://www.bing.com/ping?sitemap='.$url);
			
			// Yahoo	= http://search.yahooapis.com/SiteExplorerService/V1/ping?sitemap=	
			$this->submit('http://search.yahooapis.com/SiteExplorerService/V1/ping?sitemap='.$url);
			}
			
		$this->admin->success('The sitemap has been udpated.');
		}
	else
		{
		$this->admin->error('There was an error updating the sitemap.');	
		}
	
	
	$this->admin->respond();
	}

private function submit($url)
	{
	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_exec($ch);
	$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close($ch);
	return $httpCode;	
	}

}