<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users extends CI_Model {

// Variables
var $usid 		= '';
var $value		= '';

// Listing and Editing URLs
var $name		= 'User';
var $base 		= 'user/listing/';
var $link 		= 'user/edit/';

// Edit Folder Name
var $editor 	= 'user/edit';

// Table Settings
var $table 		= 'users';
var $index 		= 'usid';

var $select		= '';

var $join		= array();

var $filterby 	= 'useractive';
var $filterlbl 	= 'Status';
var $filters	= array('1' => 'Active', '2' => 'Inactive');
var $fixed		= array();

var $orderby 	= 'username';
var $ordering 	= 'asc';

var $searchopts	= array('username' => 'Username', 'useremail' => 'Email');

// Required Fields

var $required 	= array('username'	=> 'You must input a username.',
						'useremail' => 'You must input an email address',
						
						);

// Email Processing Variables
var $emailsub	= '';
var $emailto	= '';
var $emailtpl	= '';
var $emailsent 	= '';
var $emailfail	= '';



public function __construct()
	{
	parent::__construct();
	}

public function id()
	{
	$this->value = $this->uri->segment(1)!='ajax' && $this->uri->segment(4) ? $this->uri->segment(4) : $this->value;
	
	$this->value = isset($this->admin->postdata[$this->index]) ? $this->admin->postdata[$this->index] : $this->value;
	}

public function search()
	{
	$this->admin->model('search');
	
	// Page View and Title
	$this->admin->view 	= 'search/listing'; // search/listing | search/gallery
	$this->admin->title = $this->name.' Listing';
	
	// Set Common Settings
	$this->search->table		= $this->table;
	$this->search->index 		= $this->index;
	$this->search->session 		= $this->table;
	$this->search->base 		= $this->base;
	$this->search->link 		= $this->link;
	$this->search->process		= strtolower($this->name);
	
	$this->search->select 		= $this->select;
	$this->search->joins 		= $this->join;
	
	$this->search->options 		= $this->searchopts;
	
	$this->search->filterby 	= $this->filterby;
	$this->search->filterlbl 	= $this->filterlbl;
	$this->search->filters 		= $this->filters;
	
	$this->search->orderby 		= $this->orderby;
	$this->search->ordering 	= $this->ordering;
	
	$this->search->no_results = 'Sorry but no users matched your search. Please try searching again or search by a different field.';
	$this->search->no_records = 'No users have been setup in the system yet.';
	
	$this->search->column('useractive', 'Active', '1', 'switcher');
	$this->search->column('username', 'Order', '5', 'text');
	$this->search->column('useremail', 'Title', '6', 'text');
	
	// Run the Search
	$this->search->run();
	
	if($this->admin->inline==1)
		{
		$views = $this->search->inline();
		
		$this->admin->success('Search processed.');
		$this->admin->response(array('head' => $views['head'], 'list' => $views['list'], 'foot' => $views['foot']));
		
		$this->admin->respond();
		}
	}

public function get()
	{
	$this->id();
	
	if($this->value!='')
		{
		// Get the Record
		$this->admin->record 	= $this->db->where($this->index, $this->value)->get($this->table)->row_array();
		}
	
	unset($this->admin->record['userpassword']);
	
	// Set Page View and Title
	$this->admin->view 		= $this->editor;
	$this->admin->title 	= $this->name.' Editor';
	}

public function save()
	{
	$this->id();
	
	$this->admin->required = $this->required;
	
	$this->admin->validate();
	
	$this->compare();
	
	$this->unique();
	
	if(!isset($this->admin->response['error']))
		{
		if(isset($this->admin->postdata['userpassword']))
			{
			$this->admin->postdata['userpassword'] = md5($this->admin->postdata['userpassword']);	
			}
		
		if(isset($this->admin->postdata['userpasswordc']))
			{
			$this->admin->postdata['userpasswordc'] = md5($this->admin->postdata['userpasswordc']);	
			}
		
		$this->shake->password();
		
		if($this->value!='')
			{
			$this->db->update($this->table, $this->admin->postdata, array($this->index => $this->value)) 
				? $this->admin->success('The user has been updated.')
				: $this->admin->error('There was an error updating the uuer profile.');
			}
		else
			{
			$this->shake->generate();
			
			if($this->db->insert($this->table, $this->admin->postdata))
				{
				$this->value = $this->db->insert_id();
				
				$this->admin->response('newid', $this->value);
				
				$this->subject 		= 'Account Created for '.$this->admin->site['sitename'];
				$this->emailtpl 	= 'newuser';
				$this->emailto		= $this->admin->postdata['useremail'];
				$this->emailsent 	= 'The user has been created and an email has been sent.';
				$this->emailfail 	= 'The user has been created and however there was an error sending the email.<br />You will need to reset their password so they can receive their login details.';
				
				$this->sendemail();
				}
			else
				{
				$this->admin->success('Sorry but there was an error creating the user.');
				}
			}
		}
	
	$this->admin->respond();
	}

public function resetpass()
	{
	$this->id();
	
	$this->admin->required = array('usid' => 'The ID for the user is missing.');
	
	$this->admin->validate();
	
	if(!isset($this->admin->response['error']))
		{
		$this->get();
		
		$this->shake->generate();
		
		if($this->db->update($this->table, array('userpassword' => $this->shake->pase), array($this->index => $this->value)))
			{
			$this->subject 		= 'Password Reset for '.$this->admin->site['sitename'];
			$this->emailtpl 	= 'resetpass';
			$this->emailto		= $this->admin->record['useremail'];
			$this->emailsent 	= 'The user password has been reset and an email has been sent.';
			$this->emailfail 	= 'The user password was reset however there was an error sending the email.<br />Please contact the system administrator.';
			
			$this->sendemail();	
			}
		else
			{
			$this->admin->error('There was an error updating the user account with the new password.'.$this->db->last_query());	
			}
		}
	
	$this->admin->respond();
	}
/*
public function update()
	{
	$this->id();
	
	$this->admin->required(array(	'usid'		=> 'Your user ID is missing. Try logging out and back in.',
									'username'	=> 'You must input a username.',
									'useremail' => 'You must input an email address',
									));
	
	$this->admin->validate();
	
	if(!isset($this->admin->response['error']))
		{	
		if($this->db->update($this->table, $this->admin->postdata, array($this->index => $this->value)))
			{
			$this->admin->success('The user has been updated.');
			}
		else
			{
			$this->admin->error('There was an error updating the user profile.');
			}
		}
	
	$this->admin->respond();
	}*/


private function unique()
	{
	if($this->admin->postdata['usid']=='')
		{
		$e = $this->db->where(array('useremail' => $this->admin->postdata['useremail'], 'useractive' => 1))->get('users')->num_rows();	
		$u = $this->db->where(array('username' => $this->admin->postdata['username'], 'useractive' => 1))->get('users')->num_rows();	
		}
	else
		{
		$e = $this->db->where(array('useremail' => $this->admin->postdata['useremail'], 'usid !=' => $this->admin->postdata['usid'], 'useractive' => 1))->get('users')->num_rows();
		$u = $this->db->where(array('username' => $this->admin->postdata['username'], 'usid !=' => $this->admin->postdata['usid'], 'useractive' => 1))->get('users')->num_rows();	
		}
	
	if($e > 0)
		{
		$this->admin->error('It appears as though that email address is already in use for another administrator.');
		}
	
	if($u > 0)
		{
		$this->admin->error('It appears as though that username is already in use for another administrator.');
		}
	
	}

private function compare()
	{
	if(isset($this->admin->postdata['userpassword']) && isset($this->admin->postdata['userpasswordc']) && $this->admin->postdata['userpassword'] != $this->admin->postdata['userpasswordc'])
		{
		$this->admin->error('Sorry but the password do not match. Verify they are same and try again.');
		}	
	}

private function sendemail()
	{
	$this->admin->site();
	
	$this->load->library('email');
	
	$tpl = 
	
	$this->email->to($this->emailto);
	$this->email->from($this->admin->site['noreplyemail']);
	$this->email->subject($this->subject);
	$this->email->message($this->load->view('../../_admin/views/emails/'.$this->emailtpl, array(), true));
	
	if($this->email->send())
		{
		$this->admin->success($this->emailsent);
		}
	else
		{
		$this->admin->error($this->emailfail);
		}
	}

}