<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Contact extends CI_Model {

var $headimg	= '';
var $footimg	= '';
var $locations	= array();

public function __construct()
	{
	parent::__construct();
	
	}


public function prepare()
	{
	$this->load->model('page/fields');
	
	$this->page	->js('jquery.nicefields.js')
				->js('contact.inc.js');
	
	if(in_array('contact/locations', $this->page->elements))
		{
		$this->offices();	
		}
	}

public function submit()
	{
	$this->page->required(array(	'contact-name' 			=> 'You must input your name.',
									'contact-phone' 		=> 'You must input your contact / mobile number.',
									'contact-email' 		=> 'You must input your email address.',
									'contact-office' 		=> 'You must select your nearest office.',
									));	
		
	$this->page->validate();
	
	if(!isset($this->page->postdata['contact-interested']) || empty($this->page->postdata['contact-interested']))
		{
		$this->page->error('You must tell us what kind of booking you are interested in.');	
		}
	
	$this->page->required(array(	//'contact-interested' 	=> 'You must select what you are interested in.',
									'contact-message' 		=> 'You must input some kind of message.',
									));	
		
	$this->page->validate();
	
	if(!isset($this->page->response['error']))
		{
		$this->load->library('email');
		
		$headimg = './_media/emails/email-header.jpg';
		$footimg = './_media/emails/email-footer.jpg';
		
		$this->email->attach($headimg);
		$this->email->attach($footimg);
		
		$this->headimg = $this->email->attachment_cid($headimg);
		$this->footimg = $this->email->attachment_cid($footimg);
		
		$this->page->postdata['toemail'] = $this->page->site['contactemail'];
		
		$this->page->inline(1);
		
		$this->email->subject('Contact via '.$this->page->site['sitename'].' Website');
		$this->email->to($this->page->postdata['toemail']);
		$this->email->from($this->page->site['noreplyemail']);
		
		$msg = $this->page->emltpl('contact');
		$this->email->message($msg);
		
		$this->email->send() 
			? $this->page->success('Your enquiry to has been submitted. Thanks.')->response(array('form' => 'contact-form')) 
			: $this->page->error('There was an error submitting the enquiry. Please try again or call us during business hours.');
		
		$this->page->inline(0);
		}
	
	$this->page->respond();
	}


public function casting()
	{
	$this->page->required(array(	'casting-company'		=> 'You must enter your company name.',
									'casting-contact' 		=> 'You must input your name.',
									'casting-phone' 		=> 'You must input your contact / mobile number.',
									'casting-email' 		=> 'You must input your email address.',
									'casting-brief' 		=> 'You must input some kind of message.',
									));	
	
	if(!isset($this->page->postdata['casting-interested']) || empty($this->page->postdata['casting-interested']))
		{
		$this->page->error('You must tell us what type of item you are interested in.');	
		}
	
	$this->page->validate();
	
	if(!isset($this->page->response['error']))
		{
		$this->load->library('email');
		
		$headimg = './_media/emails/email-header.jpg';
		$footimg = './_media/emails/email-footer.jpg';
		
		$this->email->attach($headimg);
		$this->email->attach($footimg);
		
		$this->headimg = $this->email->attachment_cid($headimg);
		$this->footimg = $this->email->attachment_cid($footimg);
		
		$this->page->postdata['toemail'] = $this->page->site['contactemail'];
		
		$this->page->inline(1);
		
		$this->email->subject('Casting Enquiry via '.$this->page->site['sitename'].' Website');
		$this->email->to($this->page->postdata['toemail']);
		$this->email->from($this->page->site['noreplyemail']);
		
		$msg = $this->page->emltpl('casting');
		
		$this->email->message($msg);
		
		$this->page->inline(0);
		
		$this->email->send() 
			? $this->page->success('Your casting enquiry to has been submitted. Thanks.')->response(array('form' => 'casting-form')) 
			: $this->page->error('There was an error submitting the casting enquiry. Please try again or call us during business hours.');
		}
	
	$this->page->respond();	
	}



public function event()
	{
	$this->page->required(array(	'event-company'		=> 'You must enter your company name.',
									'event-contact' 		=> 'You must input your name.',
									'event-phone' 		=> 'You must input your contact / mobile number.',
									'event-email' 		=> 'You must input your email address.',
									'event-brief' 		=> 'You must input some kind of message.',
									));	
	
	$this->page->validate();
	
	if(!isset($this->page->response['error']))
		{
		$this->load->library('email');
		
		$headimg = './_media/emails/email-header.jpg';
		$footimg = './_media/emails/email-footer.jpg';
		
		$this->email->attach($headimg);
		$this->email->attach($footimg);
		
		$this->headimg = $this->email->attachment_cid($headimg);
		$this->footimg = $this->email->attachment_cid($footimg);
		
		$this->page->postdata['toemail'] = $this->page->site['contactemail'];
		
		$this->page->inline(1);
		
		$this->email->subject('Event Enquiry via '.$this->page->site['sitename'].' Website');
		$this->email->to($this->page->postdata['toemail']);
		$this->email->from($this->page->site['noreplyemail']);
		
		$msg = $this->page->emltpl('event');
		
		$this->email->message($msg);
		
		$this->page->inline(0);
		
		$this->email->send() 
			? $this->page->success('Your event enquiry to has been submitted. Thanks.')->response(array('form' => 'event-form')) 
			: $this->page->error('There was an error submitting the event enquiry. Please try again or call us during business hours.');
		}
	
	$this->page->respond();	
	}



public function offices()
	{
	$this->locations = $this->db->where('officeactive', 1)->order_by('officeorder')->get('offices')->result_array();	
	}


}

