<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Onecast extends CI_Model {

var $variables 	= '';
var $requrl 	= '';
var $postdata 	= array();
var $response 	= array();
var $listing	= array();
var $profile 	= array();
var $dates 		= array();
var $offices 	= array();
var $shortlist	= array();
var $shortids	= array();
var $types		= array();
var $type 		= '';
var $packages	= array();
var $images		= array();
var $emailto	= '';

public function __construct()
	{
	parent::__construct();
	
	}


public function prepare()
	{
	$this->user();
	
	$this->offices();
	
	$this->retrieve();
	
	if(in_array('onecast/listing', $this->page->elements))
		{
		$this->listing();
		}
	
	if(in_array('onecast/application', $this->page->elements))
		{
		$this->appform();
		}
	
	//echo '<pre>';die(print_r($this->shortids));
	}

// Get user shortlist
public function user()
	{
	//$this->session->unset_userdata('sm_shortlist');
	
	$this->shortids = $this->session->userdata('sm_shortlist');
	
	if(!empty($this->shortids))
		{
		$this->shortlist = array_column($this->db->where_in('talentid', $this->shortids)->order_by('talentstagename')->get('talent')->result_array(), NULL, 'talentid');	
		}	
	}

// Offices
public function offices()
	{
	$this->offices = array_column($this->db->order_by('officeorder')->get('offices')->result_array(), 'officename', 'officehash'); 	
	}


// Packages
public function packages()
	{
	// Agency Hash
	$this->variables = 'hash='.$this->page->site['onecastagency'];
	
	$this->packages = json_decode(file_get_contents($this->page->site['onecasturl'].'/api/talentPackageList?'.$this->variables), true);	
	}

// Packages
public function talenttypes()
	{
	// Agency Hash
	$this->variables = 'hash='.$this->page->site['onecastagency'];
	
	$this->types = json_decode(file_get_contents($this->page->site['onecasturl'].'/api/talentTypeList?'.$this->variables), true);	
	}




// Add to shortlist
public function shortlist()
	{
	$this->user();
	
	$this->page->required('talentid', 'The ID for the talent is missing.');
	
	if(!empty($this->shortids) && isset($this->shortids[$this->page->postdata['talentid']]))
		{
		$this->page->error('Talent is already in your list.');
		}
	
	if($this->page->validated)
		{
		$this->shortids[$this->page->postdata['talentid']] = $this->page->postdata['talentid'];
		
		$this->shortids = array_unique($this->shortids);
		
		$this->session->set_userdata('sm_shortlist', $this->shortids);
		
		$this->profile();
		
		unset($this->page->response['success']);
		
		$this->page->inline = 1;
		
		$o = $this->page->element('onecast/tpls/talsl');
		
		$this->page->success('Talent has been added to your shortlist.')->response('profile', $o);
		}
			
	$this->page->respond();	
	}

// Remove from shortlist
public function remove()
	{
	$this->user();
	
	$this->page->required('talentid', 'The ID for the talent is missing.');
	
	if(empty($this->shortlist) || !isset($this->shortlist[$this->page->postdata['talentid']]))
		{
		$this->page->error("That talent is not in your shortlist so we can't remove them.");
		}
	
	if($this->page->validated)
		{
		unset($this->shortids[$this->page->postdata['talentid']]);
		
		$this->shortids = array_unique($this->shortids);
		
		$this->session->set_userdata('sm_shortlist', $this->shortids);
		
		$this->page->success('The talent has been removed from your shortlist.');
		}
			
	$this->page->respond();		
	}

// Review shortlist
public function review()
	{
	$this->user();
	
	if(empty($this->shortids))
		{
		$this->page->error('No talent in your shortlist to review. Try adding some talent first.');
		}
	
	if($this->page->validated)
		{
		$this->page->inline = 1;
		
		$o = $this->page->element('onecast/tpls/review');
		
		$this->page->success('Shortlist loaded.')->response('review', $o);
		}
			
	$this->page->respond();		
	}

// Send shortlist
public function send()
	{
	$this->user();
	
	$this->page	->required('sendlistname', 'You must enter your name.')
				->required('sendlistphone', 'You must enter your phone number.')
				->required('sendlistemail', 'You must enter your email address.');
	
	if(empty($this->shortids))
		{
		$this->page->error('No talent in your shortlist to send. Try adding some talent first.');
		}
	
	if($this->page->validated)
		{
		$this->load->library('email');
		
		$this->emailto = $this->page->site['contactemail'];
		
		$this->email->to($this->emailto)
					->from($this->page->site['noreplyemail'])
					->subject('Talent Shortlist Enquiry from '.$this->page->postdata['sendlistname']);
		
		
		$this->email->attach('./_media/emails/email-header.jpg');
		$this->email->attach('./_media/emails/email-footer.jpg');
		
		$this->images['header'] = $this->email->attachment_cid('./_media/emails/email-header.jpg');
		$this->images['footer'] = $this->email->attachment_cid('./_media/emails/email-footer.jpg');
		
		foreach($this->shortlist as $t)
			{
			if($t['talentprimaryphoto']!='')
				{
				$this->email->attach('./_media/talent/'.$t['talentprimaryphoto']);
				$this->images[$t['talentid']] = $this->email->attachment_cid('./_media/talent/'.$t['talentprimaryphoto']);	
				}
			}
		
		$this->email->message($this->page->emltpl('shortlist'));
		
		if($this->email->send(FALSE))
			{
			if(isset($this->page->postdata['sendlistcopy']) && $this->page->postdata['sendlistcopy']=='N')
				{
				$this->emailto = $this->page->postdata['sendlistemail'];
				
				$this->email->to($this->page->postdata['sendlistemail']);
				
				$this->email->send()
					? $this->page->success('Thanks for your enquiry.<br />Your shortlist has been sent to an agent, a copy has been sent to your email address and we will be in contact.')
					: $this->page->success('Thanks for your enquiry.<br />Your shortlist has been sent to an agent but there was an error sending it to you. Don\'t worry though, we will be in contact.');	
				}
			else
				{
				$this->page->success('Thanks for your enquiry.<br />Your shortlist has been sent to an agent and we will be in contact.');
				}
			}
		else
			{			
			$this->page->error('Sorry but there was an error sending the shortlist. Please try contact us via our contact form.');
			}
		}
			
	$this->page->respond();		
	}
	
	
public function appform()
	{
	$this->page	->js('ajaxuploads/ajax.uploads.js')
				->js('ajaxuploads/uploads.inc.js')
				->js('jquery.nicefields.js')
				->js('onecast.application.inc.js');
	
	$this->packages();	
	
	$this->talenttypes();	
	}


public function appfile()
	{
	$settings = array(	'upload_path' 	=> './_media/apps/',
						'allowed_types' => array('jpg', 'png'),
						'max_size'		=> 4096,
						'encrypt_name'	=> true						
						);
	
	$this->load->library('upload', $settings);
	
	if($this->upload->do_upload('fileupload'))
		{
		$f = $this->upload->data();
		
		$this->page->success('Your photo has been uploaded and is ready to send with your application.')->response('photo', $f['file_name']);
		}
	else
		{
		$this->page->error('There was an error uploading your file. Ensure the file is under 4MB in size and that it is one of the supported file types.'.$this->upload->display_errors());	
		}
	
	$this->page->respond();	
	}


// Submit application
public function apply()
	{
	$this->page->required(array(	'firstname' 		=> 'You must tell us your first name.',
									'surname' 			=> 'You must tell us your last name.',
									'stagename' 		=> 'You must tell us what your stagename is.',
									'dob' 				=> 'You must select your date of birth.',
									'gender' 			=> 'You must select your gender.',
									'mobile' 			=> 'You must tell us your mobile number.',
									'email' 			=> 'You must tell us your email address.',
									'photofile'			=> 'You must upload your photo before you can submit the application.'
									));	
	
	$this->page->validate();
	
	if(!isset($this->page->postdata['talenttypes']) || empty($this->page->postdata['talenttypes']))
		{
		$this->page->error('You must select at least one work type that you are interested in.');	
		}
	
	if(!isset($this->page->response['error']))
		{
		$tal = array();
		
		$tal['hash'] 				= $this->page->site['onecastagency'];
		$tal['talentfirstname'] 	= isset($this->page->postdata['firstname']) 	? $this->page->postdata['firstname'] 	: 'SASS-Website-Missing-FN';
		$tal['talentsurname'] 		= isset($this->page->postdata['surname']) 		? $this->page->postdata['surname'] 		: 'SASS-Website-Missing-LN';
		$tal['talentstagename'] 	= isset($this->page->postdata['stagename']) 	? $this->page->postdata['stagename'] 	: 'SASS-Website-Missing-SN';
		$tal['talentfirstname'] 	= isset($this->page->postdata['firstname']) 	? $this->page->postdata['firstname'] 	: 'SASS-Website-Missing-FN';
		
		$tal['talentemail'] 		= isset($this->page->postdata['firstname']) 	? $this->page->postdata['firstname'] 	: 'SASS-Website-Missing-EM';
		$tal['talentmobile'] 		= isset($this->page->postdata['mobile']) 		? $this->page->postdata['mobile'] 		: 'SASS-Website-Missing-MP';
		$tal['talenttypes'] 		= isset($this->page->postdata['talenttypes']) 	? $this->page->postdata['talenttypes'] 	: 'SASS-Website-Missing-TT';
		
		if($this->page->postdata['addressb']!='')
			{
			$tal['talentbuilding'] 		= isset($this->page->postdata['addressa']) 		? $this->page->postdata['addressa'] 	: 'SASS-Website-Missing-BG';
			$tal['talentaddress'] 		= isset($this->page->postdata['addressb']) 		? $this->page->postdata['addressb'] 	: 'SASS-Website-Missing-AD';
			}
		else
			{
			$tal['talentaddress'] 		= isset($this->page->postdata['addressa']) 		? $this->page->postdata['addressa'] 	: 'SASS-Website-Missing-AD';	
			}
		
		$tal['talentpackage']		= '1';
		
		$tal['talentgender'] 		= isset($this->page->postdata['gender']) 		? $this->page->postdata['gender'] 		: 'SASS-Website-Missing-SU';
		
		$tal['talentsuburb'] 		= isset($this->page->postdata['suburb']) 		? $this->page->postdata['suburb'] 		: 'SASS-Website-Missing-SU';
		$tal['talentstate'] 		= isset($this->page->postdata['state']) 		? $this->page->postdata['state'] 		: 'SASS-Website-Missing-ST';
		$tal['talentpostcode'] 		= isset($this->page->postdata['postcode']) 		? $this->page->postdata['postcode'] 	: 'SASS-Website-Missing-PC';
		
		$tal['talentdob'] 			= isset($this->page->postdata['dob']) 	
										? date('Y-m-d', strtotime($this->page->postdata['dob'])) 	
										: 'SASS-Website-Missing-DB';
		
		$this->talenttypes();
		
		$this->page->postdata['talenttypestxt'] = '';
		
		foreach($this->page->postdata['talenttypes'] as $t)
			{
			$this->page->postdata['talenttypestxt'] = $this->page->postdata['talenttypestxt']=='' ? $this->types[$t] : $this->page->postdata['talenttypestxt'].', '.$this->types[$t];	
			}
		
		$oc = curl_init();
        curl_setopt($oc, CURLOPT_URL, $this->page->site['onecasturl'].'/api/submitTalentProfile');
		curl_setopt($oc, CURLOPT_POST, 1);
		curl_setopt($oc, CURLOPT_POSTFIELDS, http_build_query($tal));
		curl_setopt($oc, CURLOPT_RETURNTRANSFER, 1);
		$res = curl_exec($oc);
		$this->response = json_decode($res,true);
		
		curl_close($oc);
		
		
		$this->load->library('email');
		
		$this->emailto = $this->page->site['contactemail'];
		
		$this->email->to($this->emailto)
					->from($this->page->site['noreplyemail'])
					->subject('Talent Application from '.$this->page->postdata['stagename'].' via '.$this->page->sitename);
		
		
		$this->email->attach('./_media/emails/email-header.jpg');
		$this->email->attach('./_media/emails/email-footer.jpg');
		
		$this->images['header'] = $this->email->attachment_cid('./_media/emails/email-header.jpg');
		$this->images['footer'] = $this->email->attachment_cid('./_media/emails/email-footer.jpg');
		
		if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_media/apps/'.$this->page->postdata['photofile']))
			{
			$this->email->attach('./_media/apps/'.$this->page->postdata['photofile']);
			$this->images[$this->page->postdata['photofile']] = $this->email->attachment_cid('./_media/apps/'.$this->page->postdata['photofile']);
			$this->email->attach('./_media/apps/'.$this->page->postdata['photofile'], 'attachment', $tal['talentstagename'].'.'.substr($this->page->postdata['photofile'],-3));
			}
		
		$this->email->message($this->page->emltpl('application'));
		
		if($this->email->send())
			{
			isset($this->response['success'])
				? $this->page->success('Your application has been submitted into our system and sent to our new talent manager.')
				: $this->page->success('Your application has been submitted. We will be in contact.');
			}
		else
			{			
			isset($this->response['success'])
				? $this->page->success('Your application ')
				: $this->page->error();
			}
		}
	
	$this->page->respond();		
	}


public function retrieve()
	{
	if($this->page->site['onecastupdated'] < date('Y-m-d'))
		{
		// Agency Hash
		$this->variables = 'hash='.$this->page->site['onecastagency'];	
		
		// Multiple Office Hashes
		if(isset($this->page->user['offices']))
			{
			foreach($this->page->user['offices'] as $hash => $office)
				{
				if($hash!='')
					{
					$this->variables .= '&ohashes[]='.$hash;
					}
				}	
			}
		elseif(!empty($this->page->site['onecastoffices']))
			{		
			foreach($this->page->site['onecastoffices'] as $hash => $office)
				{
				if($hash!='')
					{
					$this->variables .= '&ohashes[]='.$hash;
					}
				}
			}
		
		if(isset($this->page->postdata['query']))
			{
			// Gender
			$this->variables .= $this->page->postdata['listgender']!='0' ? '&gender='.$this->page->postdata['listgender'] : '';
			// Development
			$this->variables .= '&isdev='.$this->page->postdata['listdev'];
			// Spotlight
			$this->variables .= '&spotlight='.$this->page->postdata['listspotlight'];
			// By Type
			$this->variables .= $this->page->postdata['listtype']!='0' ? '&talenttype='.$this->page->postdata['listtype'] : '';
			// Archived
			$this->variables .= $this->page->postdata['listarchived']=='1' ? '&xarchived' : '';
			// Overseas
			$this->variables .= $this->page->postdata['listoverseas']=='1' ? '&xoverseas' : '';
			}
		
		$talent = json_decode(file_get_contents($this->page->site['onecasturl'].'/api/talentListing?'.$this->variables), true);
		$this->talent = $talent['talent'];
		$types = array();
		
		// Delete the current talent and files
		$this->db->where('talentid >', 0)->delete('talent');
		
		$this->db->where('talentid >', 0)->delete('talenttypes');
		
		$this->load->helper('directory');
		
		$pts = directory_map('./_media/talent', 1);
		$tns = directory_map('./_media/talent/tn');
		
		foreach($pts as $p)
			{
			if(!in_array($p, array('.htaccess', 'index.html', 'index.php', 'tn', 'tn/', '_notes', '_notes/')) && !is_array($p) && file_exists('./_media/talent/'.$p))
				{
				unlink('./_media/talent/'.$p);	
				}
			}
		
		foreach($tns as $p)
			{
			if(!in_array($p, array('.htaccess', 'index.html', 'index.php', '_notes', '_notes/')) && !is_array($p) && file_exists('./_media/talent/tn/'.$p))
				{
				unlink('./_media/talent/tn/'.$p);	
				}
			}
		
		if(!empty($this->talent))
			{
			foreach($this->talent as $k => $r)
				{
				$this->talent[$k]['talenttypes'] = $r['talenttypes'][0];
				
				$s = $r['talenttypes'][0]!='' ? json_decode($r['talenttypes'][0], true) : array();
				
				if(!empty($s))
					{
					foreach($s as $i)
						{
						$types[] = array(	'talentid' 		=> $r['talentid'],
											'talenttype' 	=> $i,
											);	
						}
					}
				}
			
			$this->db->insert_batch('talent', $this->talent);
			
			$this->db->insert_batch('talenttypes', $types);
			
			$this->images();
			}
		}
	
	//echo '<pre>';die(print_r($this->talent));
	}

private function images()
	{
	if(!empty($this->talent))
		{
		foreach($this->talent as $talent)
			{
			if(!file_exists('./_media/talent/tn/'.$talent['talentprimaryphoto']))
				{
				copy('http://media.onecast.com.au/talent/photo/thumb/'.$talent['talentprimaryphoto'], './_media/talent/tn/'.$talent['talentprimaryphoto']);	
				}
			
			if(!file_exists('./_media/talent/'.$talent['talentprimaryphoto']))
				{
				copy('http://media.onecast.com.au/talent/photo/'.$talent['talentprimaryphoto'], './_media/talent/'.$talent['talentprimaryphoto']);	
				}	
			}
		}
	}

private function gallery()
	{
	if(!empty($this->profile->gallery))
		{
		foreach($this->profile->gallery as $photo)
			{
			if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/_media/talent/tn/'.$photo['photofilename']))
				{
				copy('http://media.onecast.com.au/talent/photo/thumb/'.$photo['photofilename'], './_media/talent/tn/'.$photo['photofilename']);	
				}
			
			if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/_media/talent/'.$profile['talentprimaryphoto']))
				{
				copy('http://media.onecast.com.au/talent/photo/'.$photo['photofilename'], './_media/talent/'.$photo['photofilename']);	
				}	
			}
		}
	}

public function paging()
	{
	$limit 	= 24;
	
	$offset = isset($this->page->postdata['page']) && $this->page->postdata['page'] > 0 ? ($this->page->postdata['page'] * $limit) : 0;
	
	if(isset($this->page->postdata['stagename']))
		{
		if($this->page->postdata['stagename']!='')
			{
			$this->db->like('talentstagename', $this->page->postdata['stagename']);
			}
		
		if($this->page->postdata['gender']!='')
			{
			$this->db->where('gender', $this->page->postdata['gender']);
			}
		
		if($this->page->postdata['office']!='')
			{
			$this->db->where('officehash', $this->page->postdata['office']);
			}
		
		if($this->page->postdata['talenttype']!='')
			{
			$this->db->join('talenttypes', 'talent.talentid = talenttypes.talentid')->where('talenttype', $this->page->postdata['talenttype'])->group_by('talenttypes.talentid');
			}
		}
	
	$this->listing = $this->db->order_by('talentrating desc, talentstagename asc')->limit($limit, $offset)->get('talent')->result_array();
	
	if(!empty($this->listing))
		{
		$o = '';
		
		$this->page->inline = 1;
		
		foreach($this->listing as $this->profile)
			{
			$o .= $this->page->element('onecast/tpls/talent');
			}
		
		$this->page	->success('Results found')
					->response('results', $o)
					->response('page', $this->page->postdata['page']+1);
		}
	else
		{
			
		}
	
	$this->page->respond();
	}

public function listing()
	{
	if($this->page->info['contentclass']!='')
		{
		switch($this->page->info['contentclass'])
			{
			case 'commercial':
			$this->type = '6';
			break;
			case 'promo':
			$this->type = '2';
			break;
			case 'actors':
			$this->type = '3';
			break;
			case 'models':
			$this->type = '4';
			break;
			case 'extras':
			$this->type = '7';
			break;
				
			}	
			
		
		$this->db->join('talenttypes', 'talent.talentid = talenttypes.talentid')->where('talenttype', $this->type)->group_by('talenttypes.talentid');
		}
	
	$limit 	= 24;
	$offset = 0;
	
	$this->listing = $this->db->order_by('talentrating desc, talentstagename asc')->limit($limit, $offset)->get('talent')->result_array();	
	
	$this->page->js('onecast.talent.inc.js');
	
	$this->talenttypes();
	}

public function profile()
	{
	if(isset($this->page->postdata['talentid']))
		{
		$this->db->where('talentid', $this->page->postdata['talentid']);	
		}
	else
		{
		$uri = end($this->uri->uri_to_assoc());
		
		$this->db->where('talentnamecurl', $uri);	
		}
	
	$this->profile = $this->db->get('talent')->row_array();	
	
	if(isset($this->page->postdata['talentid']))
		{
		if(empty($this->profile))
			{
			$this->page->error('Sorry but the talent profile could not be found.')->respond();				
			}
		else
			{
			$this->page->inline = 1;
			
			$o = $this->page->element('onecast/tpls/profile');
			
			$this->page->success('Profile found.')->response('profile', $this->profile)->response('summary', $o)->respond();
			}
		}
	}


}

