// 	JavaScript Document

var tlst = 0;

//	Window Load Bindings
$(window).bind('load', function(){
	// Set the Height of the Items to Match
	setHeights();	
	// Now configure the media list to be a maximum size to keep the toolbars and nav in display
	// N.B. If you have many folders and cannot see all nav options, comment out the css setting 2 lines below.
	var newhgt = parseFloat($(window).height() - 250);
	$('#media-files').css('height',newhgt+'px');
	});



// Nav Toggler
$('body').on('click', '.media-nav', function(){
	
	var mypath = $(this).attr('my-folder');
	
	$('#directory').val(mypath);
	
	// Nav Toggler
	$('.media-nav').not($(this)).removeClass('media-nav-active');
	$(this).addClass('media-nav-active');
	
	// Fade Out the Current Files
	$('.media-files').not($('#media-files-'+mypath)).fadeOut(250,0, function(){
		// Now fade in the new files to view
		$('#media-files-'+mypath).delay(250).fadeIn(250,0, function(){
			// Set the heights for the visible items
			setHeights();
			});
		});
	
	});

// Media Uploader

mediaUpload('sourcefile', 'files');

function mediaUploadPost(data)
	{
	if(data.result.success)
		{
		displayResponse(data.result.success, 'success');
		
		if(data.result.newfile)
			{
			$('#media-files-'+data.result.folder).append(data.result.newfile);	
			}
		}
	else if(data.result.error)
		{
		displayResponse(data.result.error, 'error');
		}
	else
		{
		displayResponse('An unknown error occurred.', 'error');
		}
	}


// Media File Tool Action
$('body').on('click', '.media-file-tool', function(){
	
	var myaction 	= $(this).attr('media-action');
	var myfile		= $(this).parent('.media-file-tools').parent('.media-file');
	var myimg		= $(this).parent('.media-file-tools').attr('media-img');
	var mypath		= $(this).parent('.media-file-tools').attr('media-path');
	
	$('#editfile').val(myimg);
	
	switch(myaction)
		{
		case 'crop':
		myfile.attr('id', 'working-img').fadeOut(250);
		cropImg(myimg, mypath);
		break;
		case 'resize':
		myfile.attr('id', 'working-img');
		resizeImg(myimg, mypath);
		break;
		case 'delete':
		myfile.attr('id', 'working-img');
		deleteImg(myimg, mypath);
		break;
		}
	 
	});




// Action Type Switches


function cropImg(img, path)
	{
	$('#workpad').html('<div id="img-crop-wrapper" my-img="'+img+'" my-path="'+path+'"><img src="/_media/'+path+'/'+img+'" id="img-crop" class="image-crop-workpad" alt="Loading" /></div><div id="img-crop-btn" class="bg-lgt-blue bg-green-hover txt-white cur-pnt">Crop Image</div><div id="img-crop-cncl" class="bg-red bg-pink-hover txt-white cur-pnt">Cancel Crop</div>').fadeIn(250, 0, function(){
		loadCropper();
		});
	}

function resizeImg(img, path)
	{
		
	}

function deleteImg(img, path)
	{
	$('#dialog').html('<p>Are you sure that you want to delete this file?</p><p class="txt-red">This cannot be undone.</p>');
	
	$('#dialog').dialog({
			resizable: false,
			height:200,
			width:400,
			modal: true,
			dialogClass: 'myDialog',
			title: 'Delete File Confirmation',
			buttons: 
				{
				'Yes Delete File': function() {
					$('#dialog').dialog('close');
					$('#loading').show();				
					var postdata = {folder:path, file:img};
					
					$.ajax({
						type: 'POST',
						url: '/ajax/files/delete',
						data: postdata,
					}).done(function(data){
						if(data.success)
							{
							$('#working-img').fadeOut(250, 0, function(){
								$('#working-img').remove();
								setHeights();
								});
							displayResponse(data.success, 'success');	
							}
						else if(data.error)
							{
							displayResponse(data.error, 'error');	
							}
						else
							{
							displayResponse('An unknown error occurred.', 'unknown');	
							}
						});	
				},
				"Cancel": function() {
					$('#dialog').dialog("close");
					$('#working-img').fadeIn(250).attr('id', null);
				}
			}});	
	}



function setHeights()
	{
	$('.media-file').each(function(){
        	tlst =  $(this).is(':visible') && $(this).height() > tlst ? $(this).height() : tlst;
    	});
	
	$('.media-file').height(tlst);
	}



// Image Cropping

$('body').on('click', '#img-crop-cncl', function(){
	
	$('#workpad').fadeOut(250,0, function(){
		$('#workpad').html('');
		});
	
	$('#working-img').fadeIn(250).attr('id', null);
	$('#uploader').fadeIn(250);
	
	});

$('body').on('click', '#img-crop-btn', function(){
	
	$('#dialog').html('<p>Are you sure that you want to crop this image?</p><p class="txt-red">This cannot be undone.</p>');
	
	$('#dialog').dialog({
			resizable: false,
			height:200,
			width:400,
			modal: true,
			dialogClass: 'myDialog',
			title: title,
			buttons: 
				{
				'Yes Crop': function() {
					$('#dialog').dialog('close');
					$('#loading').show();				
					var postdata = $('#form').serializeArray();
					
					$.ajax({
						type: 'POST',
						url: '/ajax/files/crop',
						data: postdata,
					}).done(function(data){
						
						
						$('#uploader').fadeIn(250);
						});	
				},
				"Cancel": function() {
					$('#dialog').dialog("close");
				}
			}});
	
	});




function loadCropper()
	{
	$('#uploader').fadeOut(250);
	if(myjcrop!=null){myjcrop.destroy();}
	
	var myjcrop = '';
	
	$('#img-crop').Jcrop({
		aspectRatio: false,
		onSelect: updateCoords,
		bgColor:'white'
		},
		function(){
		myjcrop = this
		});	
	}

function updateCoords(c){$('#xc').val(c.x);$('#yc').val(c.y);$('#wc').val(c.w);$('#hc').val(c.h);}


