<style>
/* Core { */
body
	{
	margin:0;
	padding:30px 0 0 0;
	font-family:"Century Gothic",Tahoma,Geneva,sans-serif;
	font-size:10px;
	color:#545454;
	}

#head
	{
	position:relative;
	top:-32px;
	left:0;
	right:0;
	height:260px;
	background-color:#fff;
	vertical-align:top;
	z-index:5;
	}

/* } */

/* Logo  {*/
#logo-wrapper
	{
	position:relative;
	top:0;
	left:0;
	right:0;
	width:100%;
	height:200px;
	}

#logo
	{
	position:relative;
	display:block;
	max-width:200px;
	max-height:100px;	
	}

/* } */

/* Summary  {*/
#summary
	{
	position:absolute;
	top:0;
	right:0;
	width:200px;
	height:200px;
	}

.summary-hdr
	{
	position:relative;
	width:200px;
	text-align:center;
	height:30px;
	line-height:30px;
	background-color:#545454;
	color:#fff;
	font-size:8px;
	text-transform:uppercase;
	/*border-top:#ccc solid 1px;	
	border-bottom:#ccc solid 1px;	*/
	}

.summary-info
	{
	position:relative;
	width:190px;
	text-align:center;
	line-height:20px;
	padding:5px;
	color:#545454;
	border-bottom:#ccc solid 1px;
	line-height:20px;	
	}

.summary-date
	{
	border-bottom:none;	
	}

/* } */

/* Company Info { */

#client
	{
	position:absolute;
	top:130px;
	left:0;
	right:0;
	width:100%;
	height:80px;
	/*margin:0 0 -22px 0;*/
	margin:0;
	text-align:justify;
	}

.client
	{
	position:absolute;
	top:30px;
	width:250px;
	height:80px;	
	}

#invoice-to
	{
	left:0;
	}

#address
	{
	right:0;
	}

.client-hdr
	{
	position:relative;
	width:240px;
	display:block;
	margin:0;
	padding:0 5px;
	height:30px;
	line-height:30px;
	font-size:8px;
	text-transform:uppercase;
	/*border-top:#ccc solid 1px;
	border-bottom:#ccc solid 1px;*/
	background-color:#545454;
	color:#fff;
	text-align:center;
	}

.client-info
	{
	position:relative;
	display:block;
	width:240px;
	margin:0;
	padding:4px 5px;
	height:50px;
	font-size:10px;
	font-weight:normal;
	color:#545454;
	border-bottom:#ccc solid 1px;	
	}

/* } */

/* Quote List */

#list
	{
	position:relative;
	display:inline-block;
	top:0;
	left:0;
	right:0;
	width:100%;
	margin:0;
	padding:0;		
	}

#list-head
	{
	position:relative;
	display:inline-block;
	width:100%;
	line-height:30px;
	margin:0;
	padding:0;
	background-color:#545454;
	color:#fff;
	}

.list-hdr-fixed
	{
	position:fixed;
	display:inline-block;
	top:0;
	left:0;
	right:0;
	width:100%;
	line-height:30px;
	margin:-1px 0 0 0;
	padding:0;
	background-color:#efefef;
	/*border-top:#ccc solid 1px;
	border-bottom:#ccc solid 1px;*/
	page-break-before:always;
	z-index:1;
	}



.items-head
	{
	border:none;
	/*border-top:#ccc solid 1px;
	border-bottom:#ccc solid 1px;*/
		
	}

.items-hdr
	{
	display:inline-block;
	font-size:8px;
	height:30px;
	line-height:30px;
	text-align:center;
	text-transform:uppercase;
	font-weight:normal;
	padding:0 5px;
	margin:0;
	border:none;
	}

.item-row
	{
	position:relative;
	width:100%;
	margin:-1px 0;
	padding:0;
	border:none;	
	/*border-top:#ccc solid 1px;
	border-bottom:#ccc solid 1px;*/
	/*height:24px;*/
	vertical-align:middle;
	overflow:hidden;
	font-size:11px;
	height:30px;
	line-height:18px;
	}

.total-row
	{
	position:relative;
	width:100%;
	margin:0 0 -1px 0;
	padding:0;
	border:none;	
	/*border-top:#ccc solid 1px;*/
	height:30px;
	line-height:30px;
	}

.total-row-first
	{
	margin:1px 0 -1px 0;	
	}

.total-row-last
	{
	/*border-bottom:#ccc solid 1px;	*/
	}

.invoice-row
	{
	background-color:#fff;	
	}

.invoice-row:nth-child(2n)
	{
	background-color:#ececec;	
	}

.item-col
	{
	display:inline-block;
	font-size:10px;
	padding:4px 4px 4px 5px;
	padding:4px 5px;
	margin:0;
	border:none;
	font-weight:normal;
	overflow:hidden;
	}

.item-name
	{
	width:260px;	
	}

.item-qty
	{
	width:50px;
	text-align:center;
	}

.item-price
	{
	width:80px;	
	text-align:right;
	}

.item-value
	{
	width:80px;
	text-align:right;
	border-right:none;	
	}

.item-ttl-lbl
	{
	width:416px;
	border:none;
	padding:5px 4px 5px 5px;
	/*border-right:#ccc solid 1px;*/
	text-align:right;
	text-transform:uppercase;
	font-size:8px;
	line-height:20px;
	color:#545454;
	}

.item-ttl-value
	{
	width:80px;
	border-right:none;
	text-align:right;
	padding:5px 4px 5px 5px;
	line-height:20px;	
	}


/* Footer { */ 
#footer
	{
	position:fixed;
	bottom:0;
	left:0;
	right:0;
	height:16px;
	line-height:16px;
	text-align:center;
	font-weight:normal;
	color:#d1d1d1;
	}

#payments
	{
	margin-top:25px;
	height:150px;
	width:100%;
	color:#545454;
	}

h1
	{
	font-size:14px;
	text-transform:uppercase;
	margin:0;
	padding:0;
	}

.method-hdr, .method-opt, .method-opt-hdr, .method-opt-info
	{
	position:relative;
	display:block;
	width:100%;
	margin:3px 0 0 0;
	padding:0;
	}

.method-hdr, .method-opt-hdr
	{
	background-color:#80868e;
	color:#fff;
	padding:0 5px;
	font-size:8px;
	height:30px;
	line-height:30px;
	text-transform:uppercase;
	}

.method-opt
	{
	width:250px;
	height:60px;
	}

.method-opt-info
	{
	height:22px;
	line-height:22px;	
	}

.method-lbl
	{
	display:inline-block;
	text-transform:uppercase;
	font-size:7px;
	width:60px;
	text-align:right;
	height:22px;
	line-height:22px;
	}

/* } */
</style>
<body>
<div id="head">
    <div id="logo-wrapper">
        <img src="http://online2.lukepelgrave.com.au/_media/images/lukepelgrave.png" alt="" id="logo" width="120" /><br><br>
        Luke Pelgrave<br>
		28 Oleron Tce<br>
		Petrie, QLD 4502        
    </div>
    <div id="summary">
        <h1 class="title">TAX INVOICE</h1>
        <div class="summary">
            <div class="summary-hdr">Date</div>
            <div class="summary-info summary-date"><?php echo date('jS M, Y', $this->admin->record['invoicedate']); ?></div>
            <div class="summary-hdr">Invoice #</div>
            <div class="summary-info"><?php echo $this->admin->record['invoice']; ?></div>
        </div>
    </div>
    <div id="client">
        <div class="client" id="invoice-to">
            <div class="client-hdr">Invoice To</div>
            <div class="client-info">
				<?php 
				echo $this->admin->record['companyname'].'<br/>'; 
				if($this->admin->record['companybuilding']!=''){echo $this->admin->record['companybuilding'].'<br />';}					
				echo $this->admin->record['companyaddress'].'<br />
				'.$this->admin->record['companysuburb'].', '.$this->admin->record['companystate'].' '.$this->admin->record['companypostcode']; 
				?>
			</div>
        </div>
        <div class="client" id="address">
            <div class="client-hdr">Customer Address</div>
            <div class="client-info">
				<?php
				echo $this->admin->record['companyname'].'<br/>'; 
				if($this->admin->record['companybuilding']!=''){echo $this->admin->record['companybuilding'].'<br />';}					
				echo $this->admin->record['companyaddress'].'<br />
				'.$this->admin->record['companysuburb'].', '.$this->admin->record['companystate'].' '.$this->admin->record['companypostcode']; 
				?>
			</div>
        </div>
    </div>
</div>
<div class="list-hdr-fixed">
    <div class="items-hdr item-name">
        Description
    </div >
    <div class="items-hdr item-qty">
        Qty / Hrs
    </div >
    <div class="items-hdr item-price">
        Unit Price
    </div >
    <div class="items-hdr item-value">
        Item Value
    </div>
</div>
<div id="footer">
    Luke Pelgrave | 0412 343 293 | email@lukepelgrave.com.au
</div>
<div id="list">
    <div id="list-head">
		<div class="items-hdr item-name">
            Description
        </div >
        <div class="items-hdr item-qty">
			Qty / Hrs
        </div >
        <div class="items-hdr item-price">
            Unit Price
        </div >
        <div class="items-hdr item-value">
            Item Value
        </div>
    </div>
<?php	
//echo $invoiceoutput;

foreach($this->admin->record['items'] as $item)
	{
	$rv = $item['itemqty'] * $item['itemprice'];
?>
    <div class="item-row invoice-row">
        <div class="item-col item-name">
            <?php echo $item['itemname']; ?>
        </div>
        <div class="item-col item-qty">
            <?php echo $item['itemqty']; ?>
        </div>
        <div class="item-col item-price">
            $<?php echo $item['itemprice']; ?>
        </div>
        <div class="item-col item-value">
            $<?php echo number_format($rv, 2); ?>
        </div>
    </div>
<?php	
	}
?>
    <div class="total-row total-row-first invoice-row">
        <div class="item-col item-ttl-lbl">
            Total
        </div>
        <div class="item-col item-ttl-value">
            $<?php echo number_format($this->admin->record['totalamount'], 2, '.', ','); ?>
        </div>
    </div>
    <div class="total-row invoice-row">
        <div class="item-col item-ttl-lbl">
            Paid To Date
        </div>
        <div class="item-col item-ttl-value">
             $<?php echo number_format($this->admin->record['paidtodate'], 2, '.', ','); ?>
        </div>
    </div>
    <div class="total-row total-row-last invoice-row">
        <div class="item-col item-ttl-lbl">
            Owing
        </div>
        <div class="item-col item-ttl-value">
             $<?php echo number_format(($this->admin->record['totalamount']-$this->admin->record['paidtodate']), 2, '.', ','); ?>
        </div>
    </div>

</div>


<div id="payments">
    <div class="method-hdr">Payment Methods</div>
    
    <div class="method-opt">
        <div class="method-opt-hdr">Direct Deposit</div>
        <div class="method-opt-info"><span class="method-lbl">Bank:</span> Queenslanders Credit Union</div>
        <div class="method-opt-info"><span class="method-lbl">BSB:</span> 804-059</div>
        <div class="method-opt-info"><span class="method-lbl">Acc:</span> 207 649</div>
        <div class="method-opt-info"><span class="method-lbl">Acc Name:</span> Luke P Pelgrave</div>
    </div>
</div>


</body>